const proxy = require('express-http-proxy');
const express = require('express');
const helmet = require('helmet');
const conf = require('./config.json');
const security = require('./modules/security');

const app = express();

// Init secure headers.
app.use(helmet({
    noCache: true,
    referrerPolicy: true
}));


app.use('/', proxy(conf.pstServer, {
    filter: (req, res) => {
        return req.originalUrl.includes('/pst/check')
            || req.originalUrl.includes('/pst/load')
            || req.originalUrl.includes('/pst/calcResult')
            || req.originalUrl.includes('/js/plugin.js')
            || req.originalUrl.includes('/js/plugin.min.js')
            || req.originalUrl.includes('/js/jquery.min.js');
    },
    proxyReqOptDecorator: proxyReqOpts => {
        let xDate = new Date().toISOString(),
            signature = security.sign(conf.apikey, xDate, conf.secret);

        proxyReqOpts.headers['APIKey'] = conf.apikey;
        proxyReqOpts.headers['X-Date'] = xDate;
        proxyReqOpts.headers['Signature'] = signature;

        return proxyReqOpts;
    },
    userResHeaderDecorator(headers, userReq, userRes, proxyReq, proxyRes) {
        delete headers['access-control-allow-methods'];
        delete headers['access-control-allow-origin'];
        delete headers['access-control-expose-headers'];
        delete headers['access-control-allow-headers'];
        userRes.removeHeader('access-control-allow-methods');
        userRes.removeHeader('access-control-allow-origin');
        userRes.removeHeader('access-control-expose-headers');
        userRes.removeHeader('access-control-allow-headers');
        return headers;
      }
}));

app.use((req, res, next) => {
    if (req.originalUrl && req.originalUrl.split('/').pop().includes('favicon') === true) {
        return res.sendStatus(204);
    }
    return next();
});


app.listen(conf.port, () => {
    console.log('The PST Proxy listen on port ' + conf.port);
});